package pt.caf_pbs.schooldiskapi.model;

import java.io.Serializable;

public class School implements Serializable {
    private String name;
    private final InstructorContainer instructors;
    private final SubjectContainer subjects;
    private final StudentContainer students;
    private final EnrollContainer enrolls;

    public School() {
        this.subjects = new SubjectContainer();
        this.students = new StudentContainer();
        this.instructors = new InstructorContainer();
        this.enrolls = new EnrollContainer();
        setDataForConsistency();
    }

    public School(String name) {
        this.name = name;
        this.subjects = new SubjectContainer();
        this.students = new StudentContainer();
        this.instructors = new InstructorContainer();
        this.enrolls = new EnrollContainer();
        setDataForConsistency();
    }

    private void setDataForConsistency() {
        this.students.setEnrolls(this.enrolls);
        this.subjects.setEnrolls(this.enrolls);
        this.subjects.setInstructors(this.instructors);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubjectContainer getSubjectContainer() {
        return subjects;
    }

    public StudentContainer getStudentContainer() {
        return students;
    }

    public InstructorContainer getInstructorContainer() {
        return instructors;
    }

    public EnrollContainer getEnrollContainer() {
        return enrolls;
    }
}
